/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.python.compiler.ClassConstants;
import org.python.compiler.ClassFile;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMaker
implements ClassConstants,
Opcodes {
    public static final int tBoolean = 0;
    public static final int tByte = 1;
    public static final int tShort = 2;
    public static final int tInteger = 3;
    public static final int tLong = 4;
    public static final int tFloat = 5;
    public static final int tDouble = 6;
    public static final int tCharacter = 7;
    public static final int tVoid = 8;
    public static final int tOther = 9;
    public static final int tNone = 10;
    public static Map<Class<?>, Integer> types = ProxyMaker.fillTypes();
    Class<?> superclass;
    Class<?>[] interfaces;
    Set<String> names;
    Set<String> supernames;
    public ClassFile classfile;
    public String myClass;

    public static Map<Class<?>, Integer> fillTypes() {
        Map<Class<?>, Integer> map = Generic.map();
        map.put(Boolean.TYPE, 0);
        map.put(Byte.TYPE, 1);
        map.put(Short.TYPE, 2);
        map.put(Integer.TYPE, 3);
        map.put(Long.TYPE, 4);
        map.put(Float.TYPE, 5);
        map.put(Double.TYPE, 6);
        map.put(Character.TYPE, 7);
        map.put(Void.TYPE, 8);
        return map;
    }

    public static int getType(Class<?> clazz) {
        if (clazz == null) {
            return 10;
        }
        Integer n = types.get(clazz);
        if (n == null) {
            return 9;
        }
        return n;
    }

    public static PyObject findPython(PyProxy pyProxy, String string) {
        PyObject pyObject;
        PyObject pyObject2 = pyProxy._getPyInstance();
        if (pyObject2 == null) {
            pyProxy.__initProxy__(new Object[0]);
            pyObject2 = pyProxy._getPyInstance();
        }
        if ((pyObject = pyObject2.__findattr__(string)) instanceof PyMethod) {
            PyMethod pyMethod = (PyMethod)pyObject;
            if (pyMethod.im_func instanceof PyReflectedFunction) {
                PyReflectedFunction pyReflectedFunction = (PyReflectedFunction)pyMethod.im_func;
                if (pyReflectedFunction.nargs > 0 && pyProxy.getClass() == pyReflectedFunction.argslist[0].declaringClass) {
                    return null;
                }
            }
        }
        Py.setSystemState(pyProxy._getPySystemState());
        return pyObject;
    }

    @Deprecated
    public ProxyMaker(String string, Class<?> clazz) {
        Class[] classArray;
        String string2 = "org.python.proxies." + string;
        Class clazz2 = clazz.isInterface() ? Object.class : clazz;
        if (clazz.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        } else {
            classArray = new Class[]{};
        }
        this(string2, clazz2, classArray);
    }

    public ProxyMaker(String string, Class<?> clazz, Class<?> ... classArray) {
        this.supernames = Generic.set();
        this.myClass = string;
        if (clazz == null) {
            clazz = Object.class;
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Given an interface,  " + clazz.getName() + ", for a proxy superclass");
        }
        this.superclass = clazz;
        if (classArray == null) {
            classArray = new Class[]{};
        }
        for (Class<?> clazz2 : classArray) {
            if (clazz2.isInterface()) continue;
            throw new IllegalArgumentException("All classes in the interfaces array must be interfaces, unlike " + clazz2.getName());
        }
        this.interfaces = classArray;
    }

    public static String mapClass(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append("/");
            n2 = n + 1;
            n = string.indexOf(".", n2);
        }
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    public static String mapType(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + ProxyMaker.mapType(clazz.getComponentType());
        }
        switch (ProxyMaker.getType(clazz)) {
            case 1: {
                return "B";
            }
            case 7: {
                return "C";
            }
            case 6: {
                return "D";
            }
            case 5: {
                return "F";
            }
            case 3: {
                return "I";
            }
            case 4: {
                return "J";
            }
            case 2: {
                return "S";
            }
            case 0: {
                return "Z";
            }
            case 8: {
                return "V";
            }
        }
        return "L" + ProxyMaker.mapClass(clazz) + ";";
    }

    public static String makeSig(Class<?> clazz, Class<?> ... classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ProxyMaker.mapType(classArray[i]);
        }
        return ProxyMaker.makeSig(ProxyMaker.mapType(clazz), stringArray);
    }

    public static String makeSig(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (String string2 : stringArray) {
            stringBuilder.append(string2);
        }
        return stringBuilder.append(')').append(string).toString();
    }

    public void doConstants() throws Exception {
        Code code = this.classfile.addMethod("<clinit>", ProxyMaker.makeSig("V", new String[0]), 8);
        code.return_();
    }

    public static void doReturn(Code code, Class<?> clazz) throws Exception {
        switch (ProxyMaker.getType(clazz)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.ireturn();
                break;
            }
            case 4: {
                code.lreturn();
                break;
            }
            case 5: {
                code.freturn();
                break;
            }
            case 6: {
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.areturn();
            }
        }
    }

    public static void doNullReturn(Code code, Class<?> clazz) throws Exception {
        switch (ProxyMaker.getType(clazz)) {
            case 10: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                code.iconst_0();
                code.ireturn();
                break;
            }
            case 4: {
                code.lconst_0();
                code.lreturn();
                break;
            }
            case 5: {
                code.fconst_0();
                code.freturn();
                break;
            }
            case 6: {
                code.dconst_0();
                code.dreturn();
                break;
            }
            case 8: {
                code.return_();
                break;
            }
            default: {
                code.aconst_null();
                code.areturn();
            }
        }
    }

    public void callSuper(Code code, String string, String string2, Class<?>[] classArray, Class<?> clazz, String string3) throws Exception {
        code.aload(0);
        int n = 1;
        block6: for (int i = 0; i < classArray.length; ++i) {
            switch (ProxyMaker.getType(classArray[i])) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    code.iload(n);
                    ++n;
                    continue block6;
                }
                case 4: {
                    code.lload(n);
                    n += 2;
                    continue block6;
                }
                case 5: {
                    code.fload(n);
                    ++n;
                    continue block6;
                }
                case 6: {
                    code.dload(n);
                    n += 2;
                    continue block6;
                }
                default: {
                    code.aload(n);
                    ++n;
                }
            }
        }
        code.invokespecial(string2, string, string3);
        ProxyMaker.doReturn(code, clazz);
    }

    public void doJavaCall(Code code, String string, String string2, String string3) throws Exception {
        code.invokevirtual("org/python/core/PyObject", string3, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
        code.invokestatic("org/python/core/Py", "py2" + string, ProxyMaker.makeSig(string2, "Lorg/python/core/PyObject;"));
    }

    public void getArgs(Code code, Class<?>[] classArray) throws Exception {
        if (classArray.length == 0) {
            code.getstatic("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
        } else {
            code.iconst(classArray.length);
            code.anewarray("java/lang/Object");
            int n = code.getLocal("[org/python/core/PyObject");
            code.astore(n);
            int n2 = 1;
            for (int i = 0; i < classArray.length; ++i) {
                code.aload(n);
                code.iconst(i);
                switch (ProxyMaker.getType(classArray[i])) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        code.iload(n2);
                        ++n2;
                        code.invokestatic("org/python/core/Py", "newInteger", "(I)Lorg/python/core/PyInteger;");
                        break;
                    }
                    case 4: {
                        code.lload(n2);
                        n2 += 2;
                        code.invokestatic("org/python/core/Py", "newInteger", "(J)Lorg/python/core/PyObject;");
                        break;
                    }
                    case 5: {
                        code.fload(n2);
                        ++n2;
                        code.invokestatic("org/python/core/Py", "newFloat", "(F)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 6: {
                        code.dload(n2);
                        n2 += 2;
                        code.invokestatic("org/python/core/Py", "newFloat", "(D)Lorg/python/core/PyFloat;");
                        break;
                    }
                    case 7: {
                        code.iload(n2);
                        ++n2;
                        code.invokestatic("org/python/core/Py", "newString", "(C)Lorg/python/core/PyString;");
                        break;
                    }
                    default: {
                        code.aload(n2);
                        ++n2;
                    }
                }
                code.aastore();
            }
            code.aload(n);
        }
    }

    public void callMethod(Code code, String string, Class<?>[] classArray, Class<?> clazz, Class<?>[] classArray2) throws Exception {
        Label label = null;
        Label label2 = null;
        String string2 = "_jcall";
        int n = 0;
        if (classArray2.length > 0) {
            label = new Label();
            label2 = new Label();
            string2 = "_jcallexc";
            n = code.getLocal("org/python/core/PyObject");
            code.astore(n);
            code.label(label);
            code.aload(n);
        }
        this.getArgs(code, classArray);
        switch (ProxyMaker.getType(clazz)) {
            case 7: {
                this.doJavaCall(code, "char", "C", string2);
                break;
            }
            case 0: {
                this.doJavaCall(code, "boolean", "Z", string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.doJavaCall(code, "int", "I", string2);
                break;
            }
            case 4: {
                this.doJavaCall(code, "long", "J", string2);
                break;
            }
            case 5: {
                this.doJavaCall(code, "float", "F", string2);
                break;
            }
            case 6: {
                this.doJavaCall(code, "double", "D", string2);
                break;
            }
            case 8: {
                this.doJavaCall(code, "void", "V", string2);
                break;
            }
            default: {
                code.invokevirtual("org/python/core/PyObject", string2, ProxyMaker.makeSig("Lorg/python/core/PyObject;", "[Ljava/lang/Object;"));
                code.ldc(clazz.getName());
                code.invokestatic("java/lang/Class", "forName", ProxyMaker.makeSig("Ljava/lang/Class;", "Ljava/lang/String;"));
                code.invokestatic("org/python/core/Py", "tojava", ProxyMaker.makeSig("Ljava/lang/Object;", "Lorg/python/core/PyObject;", "Ljava/lang/Class;"));
                code.checkcast(ProxyMaker.mapClass(clazz));
            }
        }
        if (label2 != null) {
            code.label(label2);
        }
        ProxyMaker.doReturn(code, clazz);
        if (classArray2.length > 0) {
            boolean bl = false;
            Label label3 = null;
            for (Class<?> clazz2 : classArray2) {
                label3 = new Label();
                code.label(label3);
                int n2 = code.getLocal("java/lang/Throwable");
                code.astore(n2);
                code.aload(n2);
                code.athrow();
                code.visitTryCatchBlock(label, label2, label3, ProxyMaker.mapClass(clazz2));
                ProxyMaker.doNullReturn(code, clazz);
                code.freeLocal(n2);
                if (clazz2 != Throwable.class) continue;
                bl = true;
            }
            if (!bl) {
                label3 = new Label();
                code.label(label3);
                int n3 = code.getLocal("java/lang/Throwable");
                code.astore(n3);
                code.aload(n);
                code.aload(n3);
                code.invokevirtual("org/python/core/PyObject", "_jthrow", ProxyMaker.makeSig("V", "Ljava/lang/Throwable;"));
                code.visitTryCatchBlock(label, label2, label3, "java/lang/Throwable");
                code.freeLocal(n3);
                ProxyMaker.doNullReturn(code, clazz);
            }
            code.freeLocal(n);
        }
    }

    public void addMethod(Method method, int n) throws Exception {
        boolean bl = false;
        if (Modifier.isAbstract(n)) {
            n &= 0xFFFFFBFF;
            bl = true;
        }
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        String string = ProxyMaker.makeSig(clazz, classArray);
        String string2 = method.getName();
        this.names.add(string2);
        Code code = this.classfile.addMethod(string2, string, n);
        code.aload(0);
        code.ldc(string2);
        if (!bl) {
            int n2 = code.getLocal("org/python/core/PyObject");
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code.astore(n2);
            code.aload(n2);
            Label label = new Label();
            code.ifnonnull(label);
            String string3 = ProxyMaker.mapClass(method.getDeclaringClass());
            this.callSuper(code, string2, string3, classArray, clazz, string);
            code.label(label);
            code.aload(n2);
            this.callMethod(code, string2, classArray, clazz, method.getExceptionTypes());
            this.addSuperMethod("super__" + string2, string2, string3, classArray, clazz, string, n);
        } else {
            code.invokestatic("org/python/compiler/ProxyMaker", "findPython", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Lorg/python/core/PyProxy;", "Ljava/lang/String;"));
            code.dup();
            Label label = new Label();
            code.ifnull(label);
            this.callMethod(code, string2, classArray, clazz, method.getExceptionTypes());
            code.label(label);
            code.pop();
            ProxyMaker.doNullReturn(code, clazz);
        }
    }

    private String methodString(Method method) {
        Class<?>[] classArray;
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append(":");
        for (Class<?> clazz : classArray = method.getParameterTypes()) {
            stringBuffer.append(clazz.getName());
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    protected void addMethods(Class<?> clazz, Set<String> set) throws Exception {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            int n;
            if (!set.add(this.methodString(method)) || Modifier.isStatic(n = method.getModifiers()) || Modifier.isPrivate(n)) continue;
            if (Modifier.isNative(n)) {
                n &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(n)) {
                if (Modifier.isFinal(n = n & 0xFFFFFFFB | 1)) {
                    this.addSuperMethod(method, n);
                    continue;
                }
            } else if (Modifier.isFinal(n) || !Modifier.isPublic(n)) continue;
            this.addMethod(method, n);
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.addMethods(clazz2, set);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            this.addMethods(clazz3, set);
        }
    }

    public void addConstructor(String string, Class<?>[] classArray, Class<?> clazz, String string2, int n) throws Exception {
        Code code = this.classfile.addMethod("<init>", string2, n);
        this.callSuper(code, "<init>", string, classArray, Void.TYPE, string2);
    }

    public void addConstructors(Class<?> clazz) throws Exception {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        String string = ProxyMaker.mapClass(clazz);
        for (Constructor<?> constructor : constructorArray) {
            int n = constructor.getModifiers();
            if (Modifier.isPrivate(n)) continue;
            if (Modifier.isNative(n)) {
                n &= 0xFFFFFEFF;
            }
            if (Modifier.isProtected(n)) {
                n = n & 0xFFFFFFFB | 1;
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            this.addConstructor(string, classArray, Void.TYPE, ProxyMaker.makeSig(Void.TYPE, classArray), n);
        }
    }

    public void addSuperMethod(Method method, int n) throws Exception {
        String string;
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        String string2 = ProxyMaker.mapClass(method.getDeclaringClass());
        String string3 = string = method.getName();
        if (Modifier.isFinal(n)) {
            string3 = "super__" + string;
            n &= 0xFFFFFFEF;
        }
        this.addSuperMethod(string3, string, string2, classArray, clazz, ProxyMaker.makeSig(clazz, classArray), n);
    }

    public void addSuperMethod(String string, String string2, String string3, Class<?>[] classArray, Class<?> clazz, String string4, int n) throws Exception {
        if (string.startsWith("super__")) {
            try {
                this.superclass.getMethod(string, classArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        this.supernames.add(string);
        Code code = this.classfile.addMethod(string, string4, n);
        this.callSuper(code, string2, string3, classArray, clazz, string4);
    }

    public void addProxy() throws Exception {
        this.classfile.addField("__proxy", "Lorg/python/core/PyObject;", 4);
        Code code = this.classfile.addMethod("_setPyInstance", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.return_();
        code = this.classfile.addMethod("_getPyInstance", ProxyMaker.makeSig("Lorg/python/core/PyObject;", new String[0]), 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__proxy", "Lorg/python/core/PyObject;");
        code.areturn();
        String string = "Lorg/python/core/PySystemState;";
        this.classfile.addField("__systemState", string, 132);
        code = this.classfile.addMethod("_setPySystemState", ProxyMaker.makeSig("V", string), 1);
        code.aload(0);
        code.aload(1);
        code.putfield(this.classfile.name, "__systemState", string);
        code.return_();
        code = this.classfile.addMethod("_getPySystemState", ProxyMaker.makeSig(string, new String[0]), 1);
        code.aload(0);
        code.getfield(this.classfile.name, "__systemState", string);
        code.areturn();
    }

    public void addClassDictInit() throws Exception {
        this.classfile.addInterface(ProxyMaker.mapClass(ClassDictInit.class));
        Code code = this.classfile.addMethod("classDictInit", ProxyMaker.makeSig("V", "Lorg/python/core/PyObject;"), 9);
        code.aload(0);
        code.ldc("__supernames__");
        int n = CodeCompiler.makeStrings(code, this.supernames);
        code.aload(n);
        code.freeLocal(n);
        code.invokestatic("org/python/core/Py", "java2py", ProxyMaker.makeSig("Lorg/python/core/PyObject;", "Ljava/lang/Object;"));
        code.invokevirtual("org/python/core/PyObject", "__setitem__", ProxyMaker.makeSig("V", "Ljava/lang/String;", "Lorg/python/core/PyObject;"));
        code.return_();
    }

    public void build(OutputStream outputStream) throws Exception {
        this.build();
        this.classfile.write(outputStream);
    }

    public void build() throws Exception {
        this.names = Generic.set();
        int n = this.superclass.getModifiers();
        if ((n & 0x10) != 0) {
            throw new InstantiationException("can't subclass final class");
        }
        n = 33;
        this.classfile = new ClassFile(this.myClass, ProxyMaker.mapClass(this.superclass), n);
        this.addProxy();
        this.addConstructors(this.superclass);
        this.classfile.addInterface("org/python/core/PyProxy");
        Set<String> set = Generic.set();
        this.addMethods(this.superclass, set);
        for (Class<?> clazz : this.interfaces) {
            if (clazz.isAssignableFrom(this.superclass)) {
                Py.writeWarning("compiler", "discarding redundant interface: " + clazz.getName());
                continue;
            }
            this.classfile.addInterface(ProxyMaker.mapClass(clazz));
            this.addMethods(clazz, set);
        }
        this.doConstants();
        this.addClassDictInit();
    }
}

